function custom_HTMLInputControl(id,win) {
  this.id = id;
  this.win = win;
  this.focused = false;
  this.enabled = true;
  
  this.activate();
};

custom_HTMLInputControl.prototype = {

  activate:function() {
    this.getControl();
    this.control.onfocus = custom_createCallback(this,this.onFocus,[]);
    this.control.onblur = custom_createCallback(this,this.onUnfocus,[]);
  },

  useDisabled:function() {
    var controlTagName = this.control.tagName.toLowerCase();
    if (controlTagName == "select")
      return true;
    return false;
  },

  getControl:function() {
  	if (this.control != null)
      return this.control;
    this.control = this.win.document.getElementById(this.id);
    if (this.useDisabled()) {
      if (this.control.readOnly) {
        this.control.disabled = true;
        this.control.readOnly = false;
      }
      if (this.control.disabled)
        this.disable();
      else
        this.enable();
    } else {
      if (this.control.disabled) {
        this.control.disabled = false;
        this.control.readOnly = true;
      }
      if (this.control.readOnly)
        this.disable();
      else
        this.enable();
    }
    return this.control;
  },

  focus:function() {
  	this.getControl();
    if ( (!this.focused) && (this.isFocusable()) ) {
      try {
        this.control.focus();
        this.onFocus();
      } catch(e) {
      }
    }
  },

  onFocus:function() {
    this.focused = true;
    focusOnControl(this);
  },

  unfocus:function() {
  },

  onUnfocus:function() {
    unfocusOnControl(this);
    this.focused = false;
  },

  isFocusable:function() {
  	this.getControl();

    if (custom_isJsObjectHidden(this.control))
      return false;

    if (this.useDisabled())
      return !this.control.disabled;

    return !this.control.readOnly;
  },

  enable:function() {
  	this.getControl();
    this.enabled = true;
    if (this.control != null) {
      if (this.useDisabled())
        this.control.disabled = false;
      else
        this.control.readOnly = false;
    }
  },

  disable:function() {
  	this.getControl();
    this.enabled = false;
    if (this.control != null) {
      if (this.useDisabled())
        this.control.disabled = true;
      else
        this.control.readOnly = true;
    }
  },

  getValue:function() {
  	this.getControl();
    if (this.control != null)
      return this.control.value;

    return "";
  },

  setValue:function(value) {
  	this.getControl();
    if (this.control != null)
      this.control.value = value;
  }
}

function custom_HTMLButtonImage(id, text, imagesPath, imageHeight, callbackFunction, positionControl, win) {
  this.id = id;
  this.text = text;
  this.tooltip = "";
  this.imagesPath = imagesPath;
  this.positionControl = positionControl;
  this.callbackFunction = callbackFunction;
  this.hrefCallbackFunction = "javascript:try {" + this.callbackFunction + ";custom_nothingHTML();} catch(e) {}";
  this.win = win;
  this.w = -1;
  this.h = imageHeight;
  this.depth = 0;
  this.index = 0;
  this.imageTypeNumber = 1
  this.enabled = true;
  this.focused = false;
  this.shown = true;
  this.elm = null;
  
}

custom_HTMLButtonImage.prototype = {

  activate:function() {
    this.elm = this.win.document.getElementById(this.id);
    this.a = this.win.document.createElement("A");
    this.a.href = "javascript:";
    this.a.onfocus = custom_createCallback(this,this.focus,[]);
    this.elm.appendChild(this.a);
    for (var inc = 0;inc < this.imagesPath.length;inc++) {
      var img = this.win.document.createElement("IMG");

      if (inc == 0) {
        this.image = img
        this.image.title = this.tooltip;
        if (this.w != -1) {
          this.image.width = this.w;
          this.image.height = this.h;
        }
        img.id = this.id + "Img";
        img.border = 0;
        this.a.appendChild(img);
      }
      img.src = this.imagesPath[inc];
    }
    this.image.alt = this.text;
    
    if (this.enabled) {
      this.enable();
      if (this.focused)
        this.focus();
    } else
      this.disable();
  },

  disable:function() {
    this.enabled = false;
    this.index = 1;
    if (this.a == null)
      return;
    this.changeImage();
    this.a.href = "javascript:";
    this.a.tabIndex = -1;
  },

  enable:function() {
    this.enabled = true;
    if(this.focused)
      this.index = 2;
    else
      this.index = 0;
    if (this.a == null)
      return;
    this.changeImage();
    this.a.href = this.hrefCallbackFunction;
    this.a.tabIndex = 0;
  },

  focus:function() {
    if(this.enabled && !this.focused) {
      this.focused = true;
      this.index = 2;
      if (this.a == null)
         return;
      this.changeImage();
      this.win.focus()
      this.a.focus();
      focusOnControl(this.win.custom_hTMLButtonImages[this.positionControl]);
    }
    return true;
  },
  
  unfocus:function() {
    this.focused = false;
    if (this.enabled)
      this.enable();
    else
      this.disable();
    unfocusOnControl(this.win.custom_hTMLButtonImages[this.positionControl]);
  },

  isFocusable:function() {
    return this.enabled && this.shown;
  },

  setDepth:function(depth) {
    this.depth = depth;
    if (this.image == null)
      return;
    this.changeImage();
  },

  changeImage:function() {
    var theIndex = this.index + this.depth;
    if (theIndex < this.imagesPath.length)
      this.image.src = this.imagesPath[theIndex];
  },

  setTooltip:function(text) {
    this.tooltip = text;
    if (this.image != null)
       this.image.title = this.tooltip;
  },

  show:function() {
    this.shown = true;
    this.win.custom_showJsObjectById(this.id);
  },

  hide:function() {
    this.shown = false;
    this.win.custom_hideJsObjectById(this.id);
  },

  setImages:function(imagesPath) {
  	this.imagesPath = imagesPath;
	this.image.src = this.imagesPath[this.index];
  },

  onEnter:function(){
  }
}

function custom_HTMLCheckBox(id, text, checked, callbackFunction, positionControl, win) {

  this.checked = checked;
  this.imageTypeNumber = 2;
  this.callbackFunction = callbackFunction;

  this.hTMLButtonImage = new custom_HTMLButtonImage(id,text,["checkboxcheck.gif",  "checkboxcheckdisabled.gif",  "checkboxcheckfocused.gif",
                                                      "checkboxuncheck.gif","checkboxuncheckdisabled.gif","checkboxuncheckfocused.gif"],
                                                      15, callbackFunction, positionControl, win);
  this.hTMLButtonImage.hrefCallbackFunction = "javascript:custom_clickHTMLControl(" + positionControl + ");" + this.callbackFunction;
  this.manageDisplay();

  this.activate();
}

custom_HTMLCheckBox.prototype = {

  activate:function() {
      this.hTMLButtonImage.activate();
  },

  enable:function() {
      this.hTMLButtonImage.enable();
  },

  disable:function() {
      this.hTMLButtonImage.disable();
  },

  focus:function() {
      this.hTMLButtonImage.focus();
  },

  unfocus:function() {
      this.hTMLButtonImage.unfocus();
  },

  isFocusable:function() {
      return this.hTMLButtonImage.isFocusable();
  },

  show:function() {
      this.hTMLButtonImage.show();
  },

  hide:function() {
      this.hTMLButtonImage.hide();
  },

  isCheck:function(){
      return this.checked;
  },

  setCheck:function(checked) {
    this.checked = checked;
    this.manageDisplay();
  },

  click:function() {
    this.setCheck(!this.checked);
  },

  manageDisplay:function() {
    if (this.checked)
      this.hTMLButtonImage.setDepth(0);
    else
      this.hTMLButtonImage.setDepth(3);
  },

  onEnter:function() {
  	this.hTMLButtonImage.onEnter();
  },
  
  onSpace:function(){
  },
  
  onArrowLeft:function(){
  },

  onArrowRight:function(){
  },

  onArrowUp:function(){
  },

  onArrowDown:function(){
  }
}

function custom_HTMLToggleButton(id,text,imagesPath,height,checked,callbackFunction,positionControl,win) {
  this.hTMLButtonImage = new custom_HTMLButtonImage(id,text,imagesPath,height,callbackFunction, positionControl, win);

  this.checked = checked;
  this.imageTypeNumber = 2;
  this.callbackFunction = callbackFunction;
  this.hTMLButtonImage.hrefCallbackFunction = "javascript:custom_clickHTMLControl(" + this.positionControl + ");" + this.callbackFunction;
  this.manageDisplay();
}

custom_HTMLToggleButton.prototype = {

  activate:function() {
      this.hTMLButtonImage.activate();
  },

  enable:function() {
      this.hTMLButtonImage.enable();
  },

  disable:function() {
      this.hTMLButtonImage.disable();
  },

  focus:function() {
      this.hTMLButtonImage.focus();
  },

  unfocus:function() {
      this.hTMLButtonImage.unfocus();
  },

  isFocusable:function() {
      return this.hTMLButtonImage.isFocusable();
  },

  show:function() {
      this.hTMLButtonImage.show();
  },

  hide:function() {
      this.hTMLButtonImage.hide();
  },

  setCheck:function(checked) {
    this.checked = checked;
    this.manageDisplay();
  },

  click:function() {
    this.setCheck(!this.checked);
  },

  setTooltip:function(text) {
    this.hTMLButtonImage.setTooltip(text);
  },
      
  manageDisplay:function() {
    if (this.checked)
      this.hTMLButtonImage.setDepth(0);
    else
      this.hTMLButtonImage.setDepth(3);
  }
}

function custom_HTMLRadio(id,text,selected,groupName,callbackFunction,positionControl,win) {
  this.hTMLButtonImage = new custom_HTMLButtonImage(id,text,["radioselect.gif",
                                                     "radioselectdisabled.gif",
                                                     "radioselectfocused.gif",
                                                     "radiounselect.gif",
                                                     "radiounselectdisabled.gif",
                                                     "radiounselectfocused.gif"],
                                                    12, callbackFunction,positionControl,win);
  this.groupName = groupName;
  this.imageTypeNumber = 2;
  this.checked = selected;
  this.callbackFunction = callbackFunction;
  this.hTMLButtonImage.hrefCallbackFunction = "javascript:custom_clickHTMLControl(" + this.positionControl + ");" + this.callbackFunction;
  this.manageDisplay();
}

custom_HTMLRadio.prototype = {
  activate:function() {
      this.hTMLButtonImage.activate();
  },

  enable:function() {
      this.hTMLButtonImage.enable();
  },

  disable:function() {
      this.hTMLButtonImage.disable();
  },

  focus:function() {
      this.hTMLButtonImage.focus();
  },

  unfocus:function() {
      this.hTMLButtonImage.unfocus();
  },

  isFocusable:function() {
      return this.hTMLButtonImage.isFocusable();
  },

  show:function() {
      this.hTMLButtonImage.show();
  },

  hide:function() {
      this.hTMLButtonImage.hide();
  },

  setCheck:function(checked) {
    this.checked = checked;
    this.manageDisplay();
  },

  click:function() {
    this.select();
  },

  select:function() {
    if (this.checked == true)
      return;
      for(var inc = 0;inc < this.hTMLButtonImage.win.custom_hTMLButtonImages.length;inc++) {
        if (this.groupName == this.hTMLButtonImage.win.custom_hTMLButtonImages[inc].groupName) {
          if (this.hTMLButtonImage.win.custom_hTMLButtonImages[inc] == this)
            this.hTMLButtonImage.win.custom_hTMLButtonImages[inc].checked = true;
          else
            this.hTMLButtonImage.win.custom_hTMLButtonImages[inc].checked = false;
          this.hTMLButtonImage.win.custom_hTMLButtonImages[inc].manageDisplay();
        }
      }
  },

  manageDisplay:function() {
    if (this.checked)
      this.hTMLButtonImage.setDepth(0);
    else
      this.hTMLButtonImage.setDepth(3);
  }
}


  custom_controls = [];
  custom_createHTMLInputControl = function(id) {
    var b = new custom_HTMLInputControl(id,window);
    custom_controls[custom_controls.length] = b;

    return b;
  }

  custom_hTMLButtonImages = [];
  custom_createHTMLButtonImage = function(id, text, imagePath, imageHeight, callbackFunction) {
    var b = new custom_HTMLButtonImage(id, text, imagePath, imageHeight, callbackFunction, custom_hTMLButtonImages.length, window);

    custom_hTMLButtonImages[custom_hTMLButtonImages.length] = b;
    custom_controls[custom_controls.length] = b;
    b.activate();
    
    return b;
  }

  custom_createHTMLCheckBox = function(id,text,checked,callbackFunction) {
    var b = new custom_HTMLCheckBox(id, text, checked, callbackFunction, custom_hTMLButtonImages.length, window);

    custom_hTMLButtonImages[custom_hTMLButtonImages.length] = b;
    custom_controls[custom_controls.length] = b;

    return b;
  }

  custom_createHTMLToggleButton = function(id,text,imagePath,height,checked,callbackFunction) {
    var b = new custom_HTMLToggleButton(id,text,imagePath,height,checked,callbackFunction,custom_hTMLButtonImages.length,window);

    custom_hTMLButtonImages[custom_hTMLButtonImages.length] = b;
    custom_controls[custom_controls.length] = b;

    return b;
  }

  custom_createHTMLRadio = function(id,text,selected,groupName,callbackFunction) {
    var b = new custom_HTMLRadio(id,text,selected,groupName,callbackFunction,custom_hTMLButtonImages.length,window);

    custom_hTMLButtonImages[custom_hTMLButtonImages.length] = b;
    custom_controls[custom_controls.length] = b;

    return b;
  }

  custom_clickHTMLControl = function(positionControl){
    custom_hTMLButtonImages[positionControl].click();
  }

  custom_nothingHTML = function() {
      return;
  }

  custom_createCallback = function(object,func,parameters) {
    return function() {
      var param = arguments;

      if (parameters != null)
        param = parameters;

      return func.apply(object,param);
    }
  }
  
  custom_showJsObject = function(object) {
     object.style.visibility = "visible";
     object.style.display = "block";
  }

  custom_hideJsObject = function(object) {
     object.style.visibility = "hidden";
     object.style.display = "none";
  }

  custom_showJsObjectById = function(id) {
    var object = document.getElementById(id);
    if (object != null)
      custom_showJsObject(object);
  }

  custom_hideJsObjectById = function(id) {
    var object = document.getElementById(id);
    if (object != null)
      custom_hideJsObject(object);
  }

  custom_isJsObjectHidden = function(object) {
    if ( (object.style != null) && (
         ( (object.style.display != null) && (object.style.display == "none") )
         || ( (object.style.visibility != null) && (object.style.visibility == "hidden") ) ) )
      return true;
    return custom_isObjectHidden(object);
  }
  
  custom_isObjectVisible = function(object) {
    return !(custom_doObjectClassNameContainsClass(object, "hiddenObj"));
  }

  custom_isObjectHidden = function(object) {
    return custom_doObjectClassNameContainsClass(object, "hiddenObj");
  }

  custom_doObjectClassNameContainsClass = function(object, cssClass) {
    if (object.className == null)
      return false;
    if (object.className.indexOf(cssClass) == -1)
      return false;
    return true;
  }